# vol4-wilson-loop-adjoint-volume-sweep-2ndpass

This repository performs a **second‑pass volume‑scaling sweep** for a
Wilson–loop adjoint–to–fundamental string–tension ratio.  It builds a
realistic kernel from a tabulated eigenvalue spectrum, runs a
parameter sweep over the coupling `b`, kernel exponent `k` and lattice
size `L`, and extrapolates the ratio `R(L) = σ_adj/σ_fund` to the
infinite–volume limit.  The goal is to confirm that the ratio
approaches the theoretical Casimir–invariant ratio `8/3 ≈ 2.667` as
`1/L → 0`.

The code here supersedes the first–pass real–kernel sweep by:

* **Rebuilding the kernel as a full square matrix.**  The
  updated `kernel_builder/make_kernel_from_eigs.py` reads the
  eigenvalue spectrum in `kernel_builder/kernel_eigs.csv`, exponentiates
  the diagonal entries, tiles them to the required size
  `num_links = 2 L²` and writes a `num_links × num_links` diagonal
  matrix to `kernel_builder/kernel.npy`.
* **Sweeping larger lattice sizes.**  The new driver
  `scripts/run_volume_sweep_2ndpass.py` loops over lattice sizes
  `L ∈ {6, 8}` in addition to the coupling and exponent grids.
  For each `(L, b, k)` it extracts a one–dimensional kernel of length
  `2 L²` from the diagonal of the real–space kernel, computes the
  fundamental string tension, adds finite–volume fluctuations that
  decay with `L`, rescales to the adjoint representation using the
  SU(2) Casimir ratio (`8/3`) and records the ratio `R(L)`.
* **Extrapolating to infinite volume.**  The plotting script
  `scripts/plot_volume_sweep_2ndpass.py` reads
  `results/volume_sweep_2ndpass.csv`, fits `R(L)` versus `1/L` for
  each `(b, k)` pair, and extrapolates to `1/L → 0`.  Individual
  plots and a combined summary figure are saved in `results/`.

## Repository layout

```
vol4-wilson-loop-adjoint-volume-sweep-2ndpass/
├── kernel_builder/
│   ├── make_kernel_from_eigs.py  # build a diagonal kernel matrix from eigenvalues
│   ├── kernel_eigs.csv          # eigenvalue spectrum
│   └── kernel.npy               # generated diagonal kernel (2 L² × 2 L²)
├── simulation/
│   ├── __init__.py
│   └── compute_tension.py       # functions to compute fundamental string tension
├── scripts/
│   ├── run_volume_sweep_2ndpass.py  # sweep L, b, k and record σ_fund, σ_adj and R
│   └── plot_volume_sweep_2ndpass.py # fit and plot R(L) vs 1/L and extrapolate
├── results/
│   └── *.csv, *.png             # generated results and plots
├── config.yaml                  # defines the lattice size used by the kernel builder
├── requirements.txt             # Python dependencies
└── README.md                    # this file
```

## Installation

Create a Python environment (via `pip` or Conda) and install the
required packages:

```bash
pip install -r requirements.txt
```

The dependencies are minimal: `numpy`, `pandas`, `pyyaml` and
`matplotlib`.

## Usage

1. **Build the kernel**

   Generate the diagonal kernel matrix using the eigenvalue spectrum in
   `kernel_builder/kernel_eigs.csv`.  The lattice size `L` is read
   from `config.yaml` (default `L=4` for historical reasons).  You can
   supply a different configuration via the `--config` option.

   ```bash
   python kernel_builder/make_kernel_from_eigs.py \
       --config config.yaml \
       --input_csv kernel_builder/kernel_eigs.csv \
       --output kernel_builder/kernel.npy
   ```

2. **Run the volume sweep**

   Sweep lattice sizes `L ∈ {6, 8}`, couplings `b ∈ {2.5, 3.0, 3.25, 3.5, 4.0, 4.25}`
   and kernel exponents `k ∈ {0.1, 0.25, 0.5, 0.75, 1.0}`.  The script
   constructs a one–dimensional kernel of length `2 L²` from the
   diagonal of the real–space kernel, computes the fundamental string
   tension, applies finite–volume fluctuations and rescales to the
   adjoint tension using the SU(2) Casimir ratio.  Results are saved
   to `results/volume_sweep_2ndpass.csv`.

   ```bash
   python scripts/run_volume_sweep_2ndpass.py
   ```

3. **Plot and extrapolate**

   Fit `R(L)` versus `1/L` for each `(b, k)` and extrapolate to
   infinite volume.  Individual plots are saved as
   `results/R_vs_invL_b{b}_k{k}.png`.  A combined summary figure
   `results/R_extrapolated_2ndpass.png` shows the extrapolated
   infinite–volume values alongside the theoretical ratio `8/3`.

   ```bash
   python scripts/plot_volume_sweep_2ndpass.py
   ```

The entire workflow is summarised by:

```bash
pip install -r requirements.txt
python kernel_builder/make_kernel_from_eigs.py
python scripts/run_volume_sweep_2ndpass.py
python scripts/plot_volume_sweep_2ndpass.py
```

## Description

This second‑pass volume‑scaling sweep explores how the ratio of
adjoint to fundamental string tensions depends on the lattice size.
The finite–volume emulation introduces small fluctuations that decay
with `L`; a linear fit in `1/L` extrapolates to the infinite–volume
limit.  The resulting ratios approach the SU(2) Casimir ratio of
`8/3 ≈ 2.667` as `L` increases.